//
//  SurveyHealthAppsViewControllerQ4.swift
//  HCSStudies
//
//  Created by Marvin Kowalewski on 05.10.23.
//

import Foundation
import UIKit

class SurveyHealthAppsViewControllerQ4: UIViewController {
    


    @IBOutlet var homeButton: UIButton!
    
    @IBOutlet var progressBarView: UIProgressView!
    
    @IBOutlet var continueButton: UIButton!
    
    @IBOutlet var logoImage: UIImageView!
    
    @IBOutlet var questionLabel: UILabel!
    
    @IBOutlet var answer01Label: UIButton!
    
    @IBOutlet var answer02Label: UIButton!
    
    var lastAnswerButtonClicked : String = ""
    
    let numberofQuestions : Int = 10
    
    
    
    
    override func viewDidLoad() {
        super.viewDidLoad()

        UINavigationBar.appearance().titleTextAttributes = [.foregroundColor : Colors.carmine,
                                                            .font : Fonts.mediumFontWithSize(size: 18)]
        
        homeButton.backgroundColor = UIColor.clear
        homeButton.setImage(UIImage(systemName: "homeButton"), for: .normal)
        homeButton.tintColor = UIColor.init(red: 169.0/255.0, green: 1/255.0, blue: 25/255.0, alpha: 1.0)
        
        homeButton.frame.size = CGSize(width: 15, height: 15)
        homeButton.addTarget(self, action: #selector(pressedHomeButton(_ :)), for: .touchUpInside)
        
        logoImage.alpha = 0.1

        progressBarView.progress = getProgress()
        
        
        continueButton.isEnabled = false
        continueButton.isHidden = true
        
        questionLabel.font = UIFont(name: "Avenir-Medium", size: 17) ?? UIFont.systemFont(ofSize: 17)
        
        answer01Label.backgroundColor = UIColor.clear
        answer01Label.contentHorizontalAlignment = UIControl.ContentHorizontalAlignment.left
        answer01Label.tag = 1
        answer01Label.addTarget(self, action: #selector(self.answerButton01Tapped), for: .touchUpInside)
        
        answer02Label.backgroundColor = UIColor.clear
        answer02Label.tag = 2
        answer02Label.contentHorizontalAlignment = UIControl.ContentHorizontalAlignment.left
        answer02Label.addTarget(self, action: #selector(self.answerButton02Tapped), for: .touchUpInside)
        
    }
    
    
    @objc func answerButton01Tapped(sender : UIButton) {
        lastAnswerButtonClicked = String(answer01Label.tag)
        
        answer01Label.setTitleColor(.white, for: .normal)
        Utilities.styleFilledButtonAnswerBlueSelected(answer01Label)

        answer02Label.backgroundColor = UIColor.clear
        answer02Label.tintColor = .black
        

        continueButton.isEnabled = true
        continueButton.isHidden = false
        Utilities.styleFilledButtonContinueBlue(continueButton)
    }
    @objc func answerButton02Tapped(sender : UIButton) {
        lastAnswerButtonClicked = String(answer02Label.tag)
        
        answer02Label.setTitleColor(.white, for: .normal)
        Utilities.styleFilledButtonAnswerBlueSelected(answer02Label)
        
        
        answer01Label.backgroundColor = UIColor.clear
        answer01Label.tintColor = .black
        

        continueButton.isEnabled = true
        continueButton.isHidden = false
        Utilities.styleFilledButtonContinueBlue(continueButton)
    }
    
    @objc func pressedHomeButton(_ sender: UIButton) {
        print("Home Button Pressed")
        
        let refreshAlert = UIAlertController(title: nil, message: nil, preferredStyle: UIAlertController.Style.alert)
            
        let paragraphStyle = NSMutableParagraphStyle()
        paragraphStyle.alignment = .left

        let message = "Sind Sie sicher, dass Sie die Umfrage abbrechen wollen?\nAlle bisher eingebenen Antworten gehen verloren."
        let attributedMessage = NSAttributedString(string: message, attributes: [NSAttributedString.Key.paragraphStyle: paragraphStyle])
        
        refreshAlert.setValue(attributedMessage, forKey: "attributedMessage")
        
        refreshAlert.addAction(UIAlertAction(title: "Umfrage fortsetzen", style: .cancel, handler: { (action: UIAlertAction!) in
              print("Handle Cancel Logic here")
            
        }))
        if let continueAction = refreshAlert.actions.first(where: { $0.title == "Umfrage fortsetzen" }) {
            continueAction.setValue(Colors.carmine, forKey: "titleTextColor")
        }
         
        
        refreshAlert.addAction(UIAlertAction(title: "Abbrechen", style: .default, handler: { (action: UIAlertAction!) in
              print("Handle Ok logic here")
            
        // reset all answers
        study_SmartphoneUsageuserAnswersPublic = []
        
        let storyboard = UIStoryboard(name: "Main", bundle: nil)
        let tabBarController = storyboard.instantiateViewController(withIdentifier: "InitialTBC") as! UITabBarController
        
        self.view.window?.rootViewController = tabBarController
        self.view.window?.makeKeyAndVisible()
        }))

        
        if let cancelAction = refreshAlert.actions.first(where: { $0.title == "Abbrechen" }) {
            cancelAction.setValue(Colors.greyColor, forKey: "titleTextColor")
        }
         

        present(refreshAlert, animated: true, completion: nil)
    }
    
    @IBAction func continueButton(_ sender: Any) {
        // to be sure...
        if (continueButton.isEnabled) {
            study_SmartphoneUsageuserAnswersPublic.append(lastAnswerButtonClicked)
            
            dump(study_SmartphoneUsageuserAnswersPublic)
        }
        
        let nc = self.storyboard?.instantiateViewController(withIdentifier: "SurveyHealthAppsQ5NC") as! UINavigationController
        
        nc.modalPresentationStyle = .fullScreen
        nc.modalTransitionStyle = .coverVertical
        
        present(nc, animated: true)
        
    }
    
    func getProgress() -> Float{
        let progress = Float(1) / Float(numberofQuestions)
        
        return progress
    }
    
    
}

